<?php

namespace App\Http\Controllers\API\Customers;
use App\Http\Controllers\Controller;
use App\Http\Requests\API\Customers\AddTherapistReviewRequest;
use App\Http\Requests\API\Customers\AddTherapistCommunityReviewRequest;

class APIReviewsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth:api');
    //   $this->middleware('customer');
  }


  public function addTherapistReview(AddTherapistReviewRequest $request)
  {
      $user = auth()->user();
      $customer = $user->customer;
      if($customer){
          $customer->therapist_reviews()->create($request->all());
      }
      $response = generateResponse(null,true,"Review Added Successfully",null,'collection');
      return response()->json($response);
  }
  public function addTherapistCommunityReview(AddTherapistCommunityReviewRequest $request)
  {
      $user = auth()->user();
      $customer = $user->customer;
      if($customer){
          $customer->therapist_community_reviews()->create($request->all());
      }
      $response = generateResponse(null,true,"Review Added Successfully",null,'collection');
      return response()->json($response);
  }
}
